% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_events.R
\name{find_intersecting_events}
\alias{find_intersecting_events}
\title{Find Intersecting Events}
\usage{
find_intersecting_events(ex, ey, equal.points = TRUE, closed = FALSE)
}
\arguments{
\item{ex, ey}{Event tables.}

\item{equal.points}{If \code{TRUE}, equal-valued points are considered intersecting. This is always \code{TRUE} if \code{closed = TRUE}.}

\item{closed}{If \code{TRUE}, events are interpreted as closed intervals and events sharing only an endpoint are reported as intersecting.}
}
\value{
A logical matrix with \code{ey} events as rows and \code{ex} events as columns.
}
\description{
Returns a logical matrix indicating whether or not each pair of events intersect.
}
\examples{
ex <- events(c(0, 5, 5, 10))
find_intersecting_events(ex, events(5), equal.points = FALSE) # equal points don't intersect
find_intersecting_events(ex, events(5), equal.points = TRUE)  # equal points do intersect
find_intersecting_events(ex, events(5), closed = TRUE)        # adjacent events intersect
find_intersecting_events(ex, ex)
}
