% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-fisherian.R
\name{deviance.fisher_mle}
\alias{deviance.fisher_mle}
\title{Deviance for likelihood models}
\usage{
\method{deviance}{fisher_mle}(object, null_model = NULL, ...)
}
\arguments{
\item{object}{A fisher_mle object}

\item{null_model}{Optional reduced/null model for comparison}

\item{...}{Additional arguments (ignored)}
}
\value{
Deviance value
}
\description{
Computes the deviance, which is useful for model comparison.
}
\details{
When called with a single model, returns -2 * logL (the deviance
relative to a saturated model).

When called with two models, returns the deviance difference:
D = 2 * (logL_full - logL_reduced)

Under the null hypothesis that the reduced model is correct,
D is asymptotically chi-squared with df = p_full - p_reduced.
}
