# WARNING - Generated by {fusen} from dev/flat_split_combine.Rmd: do not edit by hand

rmd_input_file <- system.file("dev-template-parsing.Rmd",
  package = "lightparser"
)
tbl_rmd <- split_to_tbl(rmd_input_file)
tbl_rmd_content <- get_content_parsedtbl(tbl_rmd)

test_that("get_content_parsedtbl can create the Rmd content for each type", {
  # yaml
  expect_equal(
    tbl_rmd_content$content[[1]],
    paste(
      c(
        "---",
        "title: dev_history.Rmd for working package",
        "output: html_document",
        "author: statnmap",
        "date: '2023-10-12'",
        "editor_options:",
        "  chunk_output_type: console",
        "---",
        ""
      ),
      collapse = "\n"
    )
  )
  # chunk
  expect_equal(
    tbl_rmd_content$content[[3]],
    "``\u0060{r development}\n#| include: no\n\nlibrary(testthat)\n``\u0060\n"
  )
  # title
  expect_equal(
    tbl_rmd_content$content[[5]],
    "# Description of your package"
  )
  # text
  expect_equal(
    tbl_rmd_content$content[[6]],
    "\nThis will fill the description of your package.\n-->"
  )
  # no params and no label
  expect_equal(
    tbl_rmd_content$content[[32]],
    "``\u0060{r}\n# duplicate empty name\n``\u0060\n"
  )
  # test the content of chunk description
  expect_true(
    all(
      grepl("^``\u0060\\{r description\\}", tbl_rmd_content$content[[7]]),
      !grepl("#\\| label: description", tbl_rmd_content$content[[7]]),
      grepl("# --> for parse tests", tbl_rmd_content$content[[7]]),
      grepl("\\nfusen::fill_description", tbl_rmd_content$content[[7]]),
      grepl("\\nusethis::use_mit_license", tbl_rmd_content$content[[7]]),
      grepl("``\u0060\\n$", tbl_rmd_content$content[[7]])
    )
  )
})

test_that("combine_tbl_to_file perfectly recreates the content of R chunks", {
  out_content <- combine_tbl_to_file(tbl_rmd_content)
  temp_purl_original <-
    suppressMessages(
      knitr::purl(
        rmd_input_file,
        output = tempfile(fileext = ".Rmd"),
        documentation = 0,
        quiet = TRUE
      )
    )
  temp_purl_output <-
    suppressMessages(
      knitr::purl(
        text = out_content,
        output = tempfile(fileext = ".Rmd"),
        documentation = 0,
        quiet = TRUE
      )
    )
  expect_equal(readLines(temp_purl_output), readLines(temp_purl_original))
})

# Test if we can correctly rebuild after removing some rows
test_that("combine_tbl_to_file is correct after removing some rows", {
  tbl_rmd_content_removed <- tbl_rmd_content[-c(1:10), ]

  input_content <- readLines(rmd_input_file)
  input_content_filtered <- input_content[-c(1:42)]

  output_content_file <- tempfile(fileext = ".Rmd")
  combine_tbl_to_file(
    tbl_rmd_content_removed,
    output_file = output_content_file
  )
  output_content <- readLines(output_content_file)

  # Compare without empty lines
  output_content_noempty <- output_content[!grepl("^$", output_content)]
  input_content_noempty <- input_content_filtered[
    !grepl("^$", input_content_filtered)
  ]
  expect_equal(
    object = output_content_noempty,
    expected = input_content_noempty
  )
})
