% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exported_functions.R
\name{browse_cran}
\alias{browse_cran}
\title{Search for CRAN packages by keyword/regex}
\usage{
browse_cran(query, fuzzy = FALSE, echo = TRUE, ignore.case = TRUE)
}
\arguments{
\item{query}{(Character) A string to \code{grep()} for.}

\item{fuzzy}{(Logical) If \code{TRUE}, enables fuzzy orderless matching. Every word in
\code{query} (i.e. every group of characters separated with a space) will be wrapped
with a lookaround \verb{(?=*KEYWORD)}. This will match keywords regardless
of the order in which those words appear.}

\item{echo}{(Logical) If \code{TRUE}, print the results to the console.}

\item{ignore.case}{(Logical) If \code{TRUE}, ignore upper/lowercase differences while
searching.}
}
\value{
Invisibly returns a dataframe of the packages that matched the query
together with their descriptions. Prints results to the console.
}
\description{
Inspired by my mysterious inability to remember what the RColorBrewer package is
actually called. Lets you find relevant CRAN packages right from your terminal.
}
\details{
When \code{browse_cran()} is run for the first time in a new session, it will
take about 6-12 seconds to download and cache CRAN data. This only happens once
per session; subsequent calls will use the cached copy.
}
\examples{
\donttest{
browse_cran("colorbrewer")  # Search by keyword

#> RColorBrewer 
#>     Provides color schemes for maps (and other graphics) designed by Cynthia 
#>     Brewer as described at http://colorbrewer2.org 
#> 
#> Redmonder 
#>     Provide color schemes for maps (and other graphics) based on the color 
#>     palettes of several Microsoft(r) products.


browse_cran("zero-inflat.*?(abund|count)")  # Search by regular expression

#> hurdlr 
#>     When considering count data, it is often the case that many more zero 
#>     counts than would be expected of some given distribution are observed.

# And five other matches...


browse_cran("network twitter api", fuzzy = TRUE)  # Order-agnostic (fuzzy) search

#> RKlout 
#>     An interface of R to Klout API v2.
}

}
