% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other-code-translations.R
\name{get_country_from_code}
\alias{get_country_from_code}
\title{Conversion from country code to country name}
\usage{
get_country_from_code(x)
}
\arguments{
\item{x}{A country code (defined in the Marc standards) or a vector
of country codes}
}
\value{
Returns the country (place) name. NA if cannot be matched
        to country in standard.
}
\description{
Takes a country code (defined in the Marc standards)
and returns the country name.
}
\details{
Interestingly, although it's called 'country' in the Marc standard,
cities, states, and other non-countries also have codes
}
\examples{

get_country_from_code("ck")
# Colombia

# tolerant of case and leading/trailing whitespace
get_country_from_code(c(" PE", "not-a-country", "nyu"))
# c("Peru", NA, "New York (State)")

}
