% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/herpSync.R
\name{herpSync}
\alias{herpSync}
\title{Synchronize species names using synonym reference table}
\usage{
herpSync(query, synonym, interactive = FALSE, return.no.matches = FALSE)
}
\arguments{
\item{query}{A character vector of taxon names to be processed (e.g., species list, phylogenetic tip labels, or trait table entries).}

\item{synonym}{A data frame with a synonym reference table (e.g., output from \code{\link{herpSynonyms}}). If not provided, the function uses the internal dataset \code{letsHerp::allSynonyms}, which may not be the most up-to-date.}

\item{interactive}{Logical. If \code{TRUE}, the function allows real-time selection when a synonym matches multiple valid names. If \code{FALSE} (default), all possible matches are returned as concatenated strings.}

\item{return.no.matches}{Logical. If \code{TRUE}, species not found in the synonym table will be returned as originally provided in the query. If \code{FALSE} (default), unmatched entries will be left blank.}
}
\value{
A data frame with the following columns:
\itemize{
\item \code{input}: original input names from the query.
\item \code{stripped}: standardized versions of the input names (e.g., without authors or formatting).
\item \code{status}: description of the outcome (e.g., \code{"updated"}, \code{"not found"}, \code{"multiple matches"}).
\item \code{updated}: best-matching valid names according to the synonym table.
}
}
\description{
Compares a user-provided list of reptile taxon names against a synonym table from The Reptile Database and returns an updated list of valid names.
Particularly useful to standardize names before analyses or when integrating heterogeneous taxonomic sources.

Supports interactive disambiguation in cases where multiple valid names are found for a given synonym. Optionally, unmatched names can be retained or returned as blank.
}
\note{
The internally stored synonym table \code{letsHerp::allSynonyms} was last updated on May 23rd, 2025.
}
\examples{
boa_syn <- letsHerp::allSynonyms[grep("^Boa\\\\s", allSynonyms$species), ]
query <- c("Vieira-Alencar authoristicus", "Boa atlantica", "Boa diviniloqua", "Boa imperator")
herpSync(query, boa_syn)

}
\references{
Liedtke, H. C. (2018). AmphiNom: an amphibian systematics tool. \emph{Systematics and Biodiversity}, 17(1), 1–6. https://doi.org/10.1080/14772000.2018.1518935
}
