% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{piechart}
\alias{piechart}
\title{Pie Chart}
\usage{
piechart(
  x,
  labels = NULL,
  col = heat.colors(5, 1),
  border = FALSE,
  main = NULL,
  ...
)
}
\arguments{
\item{x}{R object (list) of class leem. Use \code{new_leem()} function.}

\item{labels}{One or more expressions or character strings giving names for the slices}

\item{col}{Character vector. Default \code{col = heat.colors(5)}.}

\item{border}{Logical argument (default \code{FALSE}).}

\item{main}{Title name.}

\item{...}{further arguments passed to or from other methods.}
}
\description{
Draw a pie chart.
}
\examples{
library(leem)
# Example 1
school <- rep(c("high", "university", "basic"), 3:5)
x <- sample(school, 30, TRUE) |>
  new_leem() |>
  tabfreq(ordered = c("basic", "high", "university"))
# Example 2
x <- rbinom(36, 10, 0.6)
x <- new_leem(x, variable = "discrete")
x <- tabfreq(x)
piechart(x)
}
