% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_tiltmaps.R
\name{plot_tiltedmaps}
\alias{plot_tiltedmaps}
\title{Tilt raster and sf data}
\usage{
plot_tiltedmaps(
  map_list,
  layer = NA,
  palette = "viridis",
  color = "grey50",
  direction = 1,
  begin = 0,
  end = 1,
  alpha = 1
)
}
\arguments{
\item{map_list}{sf or terra/stars/raster object.}

\item{layer}{vector or list of names of each column in tilted sf object that should be used for coloring}

\item{palette}{vector of palettes provided by the \link[viridis]{viridis} and \link[scico]{scico} packages for rasters}

\item{color}{a single color applied multiple times or a vector of color strings for points or linestrings}

\item{direction}{vector of directions for \link[viridis]{viridis} and \link[scico]{scico} color palettes}

\item{begin}{vector of the of the start of interval the palette to sample colours from for \link[viridis]{viridis} and \link[scico]{scico} color palettes}

\item{end}{vector of the of the end of interval the palette to sample colours from for \link[viridis]{viridis} and \link[scico]{scico} color palettes}

\item{alpha}{vector of opacity for \link[viridis]{viridis} and \link[scico]{scico} color palettes}
}
\value{
A \code{ggplot} object with stacked maps.
}
\description{
Takes tilted maps and plots them with ggplot.
}
\examples{
\donttest{
# tilt data
tilt_landscape_1 <- tilt_map(landscape_1)
tilt_landscape_2 <- tilt_map(landscape_2, x_shift = 50, y_shift = 50)

# plot
map_list <- list(tilt_landscape_1, tilt_landscape_2)
plot_tiltedmaps(map_list, palette = "turbo")
}

}
