% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lavaan_reg.R
\name{lavaan_reg}
\alias{lavaan_reg}
\title{Extract relevant regression indices from lavaan model}
\usage{
lavaan_reg(fit, standardized_se = "model", nice_table = FALSE, ...)
}
\arguments{
\item{fit}{lavaan fit object to extract fit indices from}

\item{standardized_se}{Character string indicating the method to use for
computing standard errors and confidence intervals of standardized estimates.
Options are "model" (default, auto-detects based on model fitting method),
"delta" (uses delta method via \link[lavaan:standardizedSolution]{lavaan::standardizedsolution}), or
"bootstrap" (uses bootstrap method via \link[lavaan:parameterEstimates]{lavaan::parameterEstimates} with
\code{standardized = TRUE}, only available when the model was fitted with
bootstrap standard errors). When \code{standardized_se = "model"}, the function
chooses "bootstrap" if the fitted model used \code{se = "bootstrap"} (and
\code{bootstrap > 0}), and "delta" otherwise.}

\item{nice_table}{Logical, whether to print the table as a
\link[rempsyc:nice_table]{rempsyc::nice_table} as well as print the
reference values at the bottom of the table.}

\item{...}{Arguments to be passed to \link[rempsyc:nice_table]{rempsyc::nice_table}}
}
\value{
A dataframe, including the outcome ("lhs"), predictor ("rhs"),
standardized regression coefficient ("std.all"), corresponding
p-value, as well as the unstandardized regression coefficient
("est") and its confidence interval ("ci.lower", "ci.upper").
When \code{standardized_se = "delta"}, standardized SE and CI
are computed using the delta method. When \code{standardized_se = "bootstrap"}, standardized CI are computed using bootstrap
and SE represents the unstandardized bootstrap SE (lavaan
limitation). The SE computation method is stored as an
attribute (\code{standardized_se_method}) for verification.
}
\description{
Extract relevant regression indices from lavaan model through
\link[lavaan:parameterEstimates]{lavaan::parameterEstimates} and \link[lavaan:standardizedSolution]{lavaan::standardizedsolution}.

\strong{Uncertainty for standardized coefficients}: When \code{standardized_se = "delta"},
standard errors (SE) and confidence intervals (CI) for standardized coefficients
are computed via the delta method (as in \link[lavaan:standardizedSolution]{lavaan::standardizedsolution}).
When \code{standardized_se = "bootstrap"}, CIs for standardized coefficients are
obtained from the bootstrap distribution of the standardized statistic
(std.all) returned by \link[lavaan:parameterEstimates]{lavaan::parameterEstimates} with \code{standardized = TRUE}.
In this case, lavaan reports SE for the corresponding unstandardized parameter;
a bootstrap SE for standardized coefficients is not provided by lavaan.
lavaanExtra preserves this behavior and labels the SE source in the output.

The default \code{standardized_se = "model"} chooses "bootstrap" if the fitted
model used \code{se = "bootstrap"} (and \code{bootstrap > 0}), and "delta" otherwise.
}
\examples{
\dontshow{if (requireNamespace("lavaan", quietly = TRUE)) withAutoprint(\{ # examplesIf}
x <- paste0("x", 1:9)
(latent <- list(
  visual = x[1:3],
  textual = x[4:6],
  speed = x[7:9]
))

(regression <- list(
  ageyr = c("visual", "textual", "speed"),
  grade = c("visual", "textual", "speed")
))

HS.model <- write_lavaan(latent = latent, regression = regression)
cat(HS.model)

library(lavaan)
fit <- sem(HS.model, data = HolzingerSwineford1939)
lavaan_reg(fit)
\dontshow{\}) # examplesIf}
}
