% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_l_cai_sd.R
\name{lsm_l_cai_sd}
\alias{lsm_l_cai_sd}
\title{CAI_SD (landscape level)}
\usage{
lsm_l_cai_sd(
  landscape,
  directions = 8,
  consider_boundary = FALSE,
  edge_depth = 1
)
}
\arguments{
\item{landscape}{A categorical raster object: SpatRaster; Raster* Layer, Stack, Brick; stars or a list of SpatRasters.}

\item{directions}{The number of directions in which patches should be
connected: 4 (rook's case) or 8 (queen's case).}

\item{consider_boundary}{Logical if cells that only neighbour the landscape
boundary should be considered as core}

\item{edge_depth}{Distance (in cells) a cell has the be away from the patch
edge to be considered as core cell}
}
\value{
tibble
}
\description{
Standard deviation of core area index (Core area metric)
}
\details{
\deqn{CAI_{SD} = sd(CAI[patch_{ij}]}
where \eqn{CAI[patch_{ij}]} is the core area index of each patch.

CAI_SD is a 'Core area metric'. The metric summarises the landscape
as the standard deviation of the core area index of all patches in the landscape.
The core area index is the percentage of core area in relation to patch area.
A cell is defined as core area if the cell has no neighbour with a different
value than itself (rook's case). The metric describes the differences among all patches
in the landscape.

Because the metric is based on distances or areas please make sure your data
is valid using \code{\link{check_landscape}}.

\subsection{Units}{Percent}
\subsection{Range}{CAI_SD >= 0}
\subsection{Behaviour}{Equals CAI_SD = 0 if the core area index is identical for
all patches. Increases, without limit, as the variation of core area
indices increases.}
}
\examples{
landscape <- terra::rast(landscapemetrics::landscape)
lsm_l_cai_sd(landscape)

}
\references{
McGarigal K., SA Cushman, and E Ene. 2023. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical Maps. Computer software program produced by the authors;
available at the following web site: https://www.fragstats.org
}
\seealso{
\code{\link{lsm_p_cai}},
\code{\link[stats]{sd}} \cr
\code{\link{lsm_c_cai_mn}},
\code{\link{lsm_c_cai_sd}},
\code{\link{lsm_c_cai_cv}}, \cr
\code{\link{lsm_l_cai_mn}},
\code{\link{lsm_l_cai_cv}}
}
