% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/start-listening.R
\name{wait_for_event}
\alias{wait_for_event}
\title{Query the next invocation endpoint to get the next input}
\usage{
wait_for_event(config = lambda_config())
}
\arguments{
\item{config}{A list of configuration values as created by the
\code{lambda_config} function.}
}
\description{
The query will receive a response when an input is queued up. If there is no
input waiting, the Lambda instance will be shut down after a period of
inactivity.
}
\details{
The Request ID is unique for each input of a Lambda. It is carried by the
"lambda-runtime-aws-request-id" header of the response from the next
invocation endpoint (see \code{\link{endpoints}}).

If an error occurs when extracting the Request ID it is impossible to post it
to the invocation error endpoint as that is determined by the Request ID. We
log the error and move on.
}
\keyword{internal}
