% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lama_translate.R
\name{translate_vector}
\alias{translate_vector}
\title{This function relabels a vector}
\usage{
translate_vector(val, translation, keep_order, to_factor, is_translated,
  err_handler)
}
\arguments{
\item{val}{The vector that should be relabeled. Allowed are all vector types (also factor).}

\item{translation}{Named character vector holding the label assignments.}

\item{keep_order}{A logical flag. If the vector in \code{val}
is a factor variable and \code{keep_order} is set to \code{TRUE}, then
the order of the original factor variable is preserved.}

\item{to_factor}{A logical flag. If set to \code{TRUE}, the the resulting
labeled variable will be a factor and a plain character vector
otherwise.}

\item{is_translated}{A logical flag. If \code{is_translated = TRUE}, then
\code{val} must be a character vector holding the right labels (character strings)
and will be turned into a factor with ordering given in the translation
(except for the case when \code{keep_order = TRUE}).}

\item{err_handler}{An error handling function}
}
\value{
A factor vector holding the assigned labels
}
\description{
This function relabels a vector
}
