% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lama_mutate.R
\name{lama_mutate}
\alias{lama_mutate}
\alias{lama_mutate.lama_dictionary}
\alias{lama_mutate_}
\alias{lama_mutate_.lama_dictionary}
\title{Change or append a variable translation to an existing \link[=new_lama_dictionary]{lama_dictionary} object}
\usage{
lama_mutate(.data, ...)

\method{lama_mutate}{lama_dictionary}(.data, ...)

lama_mutate_(.data, key, translation)

\method{lama_mutate_}{lama_dictionary}(.data, key, translation)
}
\arguments{
\item{.data}{A \link[=new_lama_dictionary]{lama_dictionary} object}

\item{...}{One or more unquoted expressions separated by commas. Use named
arguments, e.g. \code{new_transation_name = c(a = "A", b = "B")}, to set
translations (named character vectors) to new translation names.
If you want to delete an existing translation assign the value \code{NULL}
(e.g. \code{old_translation = NULL}). It is also
possible use complex expressions as long as the resulting object is a valid
translation object (named character vector).
Furthermore, it is possible to use translation names that are already
existing in the dictionary, in order to modify them
(e.g. \code{new_translation = c(v = "V", w = "W", old_translation, z = "Z")}, where
\code{old_translation = c(x = "X", y = "Y")}).}

\item{key}{The name of the variable translation that should be altered.
It can also be variable translation name that does not exist yet.}

\item{translation}{A named character vector holding the new variable
translation that should be assigned to the name given in argument \code{key}.
The names of the character vector \code{translation} correspond to the
original variable values that should be replaced by the new labels.
The values in the character vector \code{translations} are the labels
that should be assigned to the original values.}
}
\value{
An updated \link[=new_lama_dictionary]{lama_dictionary} class object.
}
\description{
The functions \code{\link[=lama_mutate]{lama_mutate()}} and \code{\link[=lama_mutate_]{lama_mutate_()}} alter a
\link[=new_lama_dictionary]{lama_dictionary} object. They can be used to alter,
delete or append a translations to a
\link[=new_lama_dictionary]{lama_dictionary} object.
The function \code{\link[=lama_mutate]{lama_mutate()}} uses named arguments to assign the translations
to the new names (similar to \code{dplyr::mutate}), whereas the function
\code{\link[=lama_mutate_]{lama_mutate_()}} is takes a character string \code{key} holding the
name to which the translation should be assigned and a named character
vector \code{translation} holding the actual translation mapping.
}
\examples{
  # initialize lama_dictinoary
  dict <- new_lama_dictionary(
    subject = c(en = "English", ma = "Mathematics"),
    result = c("1" = "Very good", "2" = "Good", "3" = "Not so good")
  )
 
  ## Example-1: mutate and append with 'lama_mutate'
  # add a few subjects and a few grades
  dict_new <- lama_mutate(
    dict, 
    subject = c(bio = "Biology", subject, sp = "Sports"),
    result = c("0" = "Beyond expectations", result, "4" = "Failed", NA_ = "Missed")
  )
  # the subjects "Biology" and "Sports" were added
  # and the results "Beyond expectations", "Failed" and "Missed"
  dict_new

  ## Example-2: delete with 'lama_mutate'
  dict_new <- lama_mutate(
    dict, 
    subject = NULL
  )
  dict_new

  ## Example-3: Alter and append with 'lama_mutate_'
  # generate the new translation (character string)
  subj <- c(
    bio = "Biology",
    lama_get(dict, subject),
    sp = "Sports"
  )
  # save the translation under the name "subject"
  dict_new <- lama_mutate_(
    dict,
    key = "subject",
    translation = subj
  )
  # the translation "subject" now also contains
  # the subjects "Biology" and "Sports"
  dict_new

  ## Example-4: Delete with 'lama_mutate_'
  # save the translation under the name "subject"
  dict_new <- lama_mutate_(
    dict,
    key = "subject",
    translation = NULL
  )
  # the translation "subject" was deleted
  dict_new
  
}
\seealso{
\code{\link[=lama_translate]{lama_translate()}}, \code{\link[=lama_to_factor]{lama_to_factor()}}, \code{\link[=lama_translate_all]{lama_translate_all()}},
\code{\link[=lama_to_factor_all]{lama_to_factor_all()}}, \code{\link[=new_lama_dictionary]{new_lama_dictionary()}},
\code{\link[=as.lama_dictionary]{as.lama_dictionary()}}, \code{\link[=lama_rename]{lama_rename()}}, \code{\link[=lama_select]{lama_select()}},
\code{\link[=lama_merge]{lama_merge()}}, \code{\link[=lama_read]{lama_read()}}, \code{\link[=lama_write]{lama_write()}}
}
