% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kvk_retrieve.R
\name{kvk_get_vestigingsprofiel}
\alias{kvk_get_vestigingsprofiel}
\title{Retrieve the Vestigingsprofiel for a given establishment number}
\usage{
kvk_get_vestigingsprofiel(
  vestigingsnummer,
  geoData = FALSE,
  test_environment = FALSE
)
}
\arguments{
\item{vestigingsnummer}{A string representing the establishment number for
which the profile is requested.}

\item{geoData}{A logical value indicating whether geo-data should be included
in the response. Defaults to \code{FALSE}. If \code{TRUE}, the response will include
geo-data.}

\item{test_environment}{A logical value indicating whether to use the test
environment (\code{TRUE}) or the production environment (\code{FALSE}). Defaults to
\code{FALSE}.}
}
\value{
A tibble containing the retrieved establishment profile. If \code{geoData = TRUE}, the returned tibble will also include geographical information.
}
\description{
This function retrieves the establishment profile (\code{vestigingsprofiel}) for
a given establishment number (\code{vestigingsnummer}) using the KvK
Vestigingsprofiel API.
}
\details{
The function also supports the \code{test_environment} argument. When set to
\code{TRUE}, the function will query the KvK test API environment, providing a
set of fictitious test data.

The function retrieves data from the KvK Vestigingsprofiel API. If
\code{geoData = TRUE}, geo-data (e.g., location data) will be included in the
returned profile.

\strong{Important:} If \code{test_environment = TRUE}, no actual API key is required. You will be using
test data from the KvK test environment.
}
\examples{
\dontshow{if (nzchar(Sys.getenv("KVK_API_KEY"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Examples using the production API (requires API key)
# Retrieve vestigingsprofiel for a given establishment number
vestigingsprofiel <- kvk_get_vestigingsprofiel(vestigingsnummer = "000038509504")
print(vestigingsprofiel)

# Retrieve vestigingsprofiel with geo-data
vestigingsprofiel_geo <- kvk_get_vestigingsprofiel(
  vestigingsnummer = "000038509504", 
  geoData = TRUE
)

# Examples using test environment (no API key required)
vestigingsprofiel_test <- kvk_get_vestigingsprofiel(
  vestigingsnummer = "000019716893", 
  test_environment = TRUE
)
print(vestigingsprofiel_test)
\dontshow{\}) # examplesIf}
}
