% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{boston_fire_incidents_weekly}
\alias{boston_fire_incidents_weekly}
\title{boston_fire_incidents_weekly}
\format{
A dataframe with 239 rows and 16 variables:
\describe{
          \item{week}{first day of a given week (Sunday), date.}
          \item{incidents}{summarized count of fire incidents from the Sunday in the week variable to the Saturday before the next week.}
          \item{new.years.ind}{1 if YYYY-01-01 or YYYY-12-31 occur during the week else 0.}
          \item{christmas.ind}{1 if YYYY-12-24 or YYYY-12-25 occur during the week else 0.}
          \item{thanksgiving.ind}{1 if the holiday Thanksgiving occurs during the week else 0.}
          \item{veterans.ind}{1 if YYYY-11-11 occurs during the week else 0.}
          \item{indigenous.ind}{1 if the holiday Indigenous Peoples Day occurs during the week else 0.}
          \item{labor.ind}{1 if the holiday Labor Day occurs during the week else 0.}
          \item{july4.ind}{1 if YYYY-07-04 occurs during the week else 0.}
          \item{juneteenth.ind}{1 if YYYY-06-19 occurs during the week and the week st is >= '2020-06-01' else 0.}
          \item{memorial.ind}{1 if the holiday Memorial Day occurs during the week else 0.}
          \item{patriots.ind}{1 if the holiday Patriot's Day occurs during the week else 0.}
          \item{st.patricks.ind}{1 if YYYY-03-17 occurs during the week else 0.}
          \item{presidents.ind}{1 if the holiday President's Day occurs during the week else 0.}
          \item{mlk.ind}{1 if the holiday Martin Luther King Jr. Day occurs during the week else 0.}
          \item{covid.soe.ind}{1 if the week contains days between '2020-03-10' and '2021-06-15' when a state of emergency for COVID-19 was declared in Massachusetts else 0.}
}
}
\source{
\url{https://data.boston.gov/dataset/fire-incident-reporting}
}
\usage{
boston_fire_incidents_weekly
}
\description{
A dataset which contains the weekly count of fire incidents in the city of
Boston, MA, USA, as well as a number of holiday indicators and one indicator
for the period where a COVID-19 state of emergency was declared in Massachusetts.
Data is present for weeks between 2017-01-01 and 2021-07-25. Derived by Matthew Trupiano
from a series of .csv files hosted on \url{https://data.boston.gov/}.
}
\keyword{datasets}
