% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{heart}
\alias{heart}
\title{Heart Disease data set}
\format{
A data frame with 297 rows and 14 variables:
\describe{
  \item{age}{Age in years (numerical).}
  \item{sex}{Sex: 1 = male, 0 = female (logical).}
  \item{cp}{Four chest pain types: (1) typical angina, (2) atypical angina
  (3)non-anginal pain, (4) asymptomatic (categorical).}
  \item{trestbps}{Resting blood pressure (in mm Hg on admission to
  the hospital) (numerical).}
  \item{chol}{Serum cholestoral in mg/dl (numerical).}
  \item{fbs}{Fasting blood sugar more than 120 mg/dl (logical).}
  \item{restecg}{Resting electrocardiographic results: (0) normal,
  (1) having ST-T wave abnormality, (2) showing probable or definite
  left ventricular hypertrophy by Estes' criteria (categorical).}
  \item{thalach}{Maximum heart rate achieved (numerical).}
  \item{exang}{Exercise induced angina (logical).}
  \item{oldpeak}{ST depression induced by exercise relative to
  rest (numerical).}
  \item{slope}{The slope of the peak exercise ST segment: (1) upsloping,
  (2) flat, (3) downsloping (categorical).}
  \item{ca}{Number of major vessels (0-3) colored by flourosopy (numerical).}
  \item{thal}{(3) normal, (6) fixed defect, (7) reversable defect
  (categorical).}
  \item{class}{Diagonosis of heart disease (4 classes). It can be 2 classes
  by setting 0 for 0 values and 1 for non-0 values.}
}
}
\source{
The data set is taken from machine learning repository of UCI.
The original data set consists of 303 patients with 6 NA's. Then,
the missing values are omitted such that it reduces into 297 patients.

\url{https://archive.ics.uci.edu/ml/datasets/Heart+Disease}
}
\usage{
heart
}
\description{
A mixed variable dataset containing 14 variables of 297 patients for
their heart disease diagnosis.
}
\references{
Lichman, M. (2013). UCI machine learning repository.
}
\keyword{datasets}
