% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getEnsemblRegionFeatures.R
\name{getEnsemblRegionFeatures}
\alias{getEnsemblRegionFeatures}
\title{Get features of a given region.}
\usage{
getEnsemblRegionFeatures(species, chromosome, start, end, features)
}
\arguments{
\item{species}{Species name or alias (e.g., homo_sapiens, human).}

\item{chromosome}{Chromosome name in Ensembl format (without 'chr' prefix).}

\item{start}{Start position of the region.}

\item{end}{End position of the region.}

\item{features}{List of region features to retrieve from Ensembl. Valid
options include "band", "gene", "transcript", "cds", "exon", "repeat",
"simple", "misc", "variation", "somatic_variation",
"structural_variation", "somatic_structural_variation", "constrained",
"regulatory", "motif", "peak", "other_regulatory", "array_probe", "mane".}
}
\value{
A \code{data.table} containing the requested Ensembl features.
}
\description{
Function fetches various genomic features for a specified region from the
Ensembl database. It allows specifying the species, chromosome, region range,
and types of features to query.
}
