% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matr.R
\name{matr}
\alias{matr}
\title{Estimate the bandwidth parameter for a gaussian kernel using MATr}
\usage{
matr(dat, k, grid, tol = 0.01)
}
\arguments{
\item{dat}{data vector}

\item{k}{number of clusters}

\item{grid}{parameter grid to search on}

\item{tol}{tolerence for choosing the "best" sigma values. Reducing the
tolerance will give larger values of the bandwidth parameter}
}
\value{
A list with two elements. The first, \code{l}, contains the trace value for
each of the values in \code{grid}. The second, \code{best}, contains the best value.
}
\description{
given data and number of clusters K, choose a bandwidth from a
grid according to the MATR algorithm
}
