\name{simulations}
\alias{kc.simul}
\alias{sample.caco}
\alias{summary.kin.cohort.sample}

\title{ simulation of kin cohort studies }
\description{
Functions to simulate data for kin-cohort analysis
}
\usage{

kc.simul(nfam, f, hr, rand = 0, mean.sibs = 2, mean.desc = 1.5, 
         a.age = 8, b.age = 80, a.cancer = 3, b.cancer = 180 )

sample.caco(object, p.cases = 1, caco.ratio = 1, verbose = TRUE)

\method{summary}{kin.cohort.sample}(object,\dots)
}
\arguments{
   \item{nfam}{number of families to be generated }
	\item{f}{allele frequency}
	\item{hr}{hazard ratio for disease carriers relative noncarriers}
	\item{rand}{variance of random effect for cancer incidence (ratio of hr)}
	
	\item{mean.sibs}{ mean number of sibllings and descendants (~Poisson)}
	\item{mean.desc}{ mean number of sibllings and descendants (~Poisson)}
	\item{a.age}{shape parameter for age (~Weibull)}
	\item{b.age}{scale parameter for age (~Weibull)}
	
	\item{a.cancer}{shape parameter for cancer incidence (~Weibull)}
	\item{b.cancer}{scale parameter for cancer incidence (~Weibull)}

   \item{object}{object of class \code{kin.cohort.sample} and \code{data.frame} }

   \item{p.cases}{proportion of cases (affected) to include in sample. if more than 1, the exact number is assumed}
   \item{caco.ratio}{ ratio of controls per case to include in sample }
	\item{verbose}{show the number of cases and controls sampled}
	\item{\dots}{additional arguments}
}
\value{
	object of class \code{kin.cohort.sample} and \code{data.frame} with fields

	\item{famid }{family id}
	\item{rel}{ relative type (0=proband, 1=parents, 2=sibblings, 3=descendants)}
	\item{age}{ current age of each subject}
	\item{gender}{gender (0=male, 1=female)}
	\item{carrier}{carrier status of proband (0=noncarrier, 1=carrier), common for all family members }
	\item{cancer}{affected (0=no, 1=yes) }
	\item{agecancer}{ age at diagnosis or current age if not affected}
	\item{real.carrier}{ carrier status or relatives (0=noncarrier, 1=carrier ) }
}
\details{
\code{kc.simul} will generate a cohort of probands of size \code{nfam}. Default parameters simulate a typical cancer study. Each of them will be assigned: a \code{carrier} status with probability \eqn{f^2+2f(1-f)}; a current \code{age} 
drawn from a Weibull distribution with parameters \code{a.age} and \code{b.age}; an age at diagnosis (\code{agecancer}) drawn from 
a Weibull distribution with parameters \code{a.cancer} and \code{b.cancer}, if noncarrier. For carries, the scale (\code{b.cancer}) is 
shifted to get the desired hazard ratio (\code{hr}). If \code{rand}>0, then a family specific random effect is also added, drawn from a normal distribution with mean 0 and sd \code{rand}.
If \code{agecancer}< \code{age} then the disease status (\code{cancer}) will be 1, 0 otherwise. 

First degree relatives are generated for each proband: two parents, a random number of sibblings (drawn from a Poisson withe mean \code{mean.sibs}), and 
a random number of descendants (drawn from a Poisson with mean \code{mean.desc}). Each of them is assiggned a \code{carrier} status with probability according 
to mendelian transmission conditional of the proband carrier status. 
Current \code{age} for relatives are generated conditional on the proband's age, with random draws from normal distribution. Age at diagnosis (\code{agecancer}) is assumed independent, except for the optional family random effect.
Gender is assigned at random with probability 0.5 for all individuals.

Note that the simulation of residual familial correlation with a random effect (\code{rand$>0}) does not mantain the desired hazard ratio (\code{hr}).

The generic function \code{summary} will show the number and proportion of carriers and affected subjects in the sample.

\code{sample.caco} will sample (from a simulation generated by \code{kc.simul}) a subset of cases (afected probands) and controls (unaffected probands) and their relatives. Currently only random sampling of controls is implemented (no matching). Sampling fraction is controled by \code{caco.ratio}.

Currently, only one gene and one disease are simulated.

}
\examples{
\dontrun{
set.seed(7)
## cohort 
s<-kc.simul(4000, f=0.03, hr=5)
summary(s)

## exclude probands
m.coh<- kc.marginal(s$agecancer, s$cancer, factor(s$carrier), s$rel,
                    knots=c(30,40,50,60,70,80,90), f=0.03)
m.coh

## relatives only
r.coh<- coxph(Surv(agecancer,cancer)~real.carrier, data=s)
print(exp(coef(r.coh)))

## probands only
p.coh<- coxph(Surv(agecancer,cancer)~carrier, data=s)
print(exp(coef(p.coh)))

## case-control
s.cc<- sample.caco(s)
summary(s.cc)

## exclude probands
m.caco<- kc.marginal(s.cc$agecancer, s.cc$cancer, factor(s.cc$carrier), 
                     s.cc$rel, knots=c(30,40,50,60,70,80,90), f=0.03)
m.caco

## relatives only
r.caco<- glm(cancer~real.carrier, family=binomial, data=s.cc, subset=(s.cc$rel!=0))
print(exp(coef(r.caco)[2]))

## probands only
p.caco<- glm(cancer~carrier, family=binomial, data=s.cc, subset=(s.cc$rel==0))
print(exp(coef(p.caco)[2]))
}
}

\keyword{survival}
\keyword{methods}
