% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/egfr_ekfc.R
\name{egfr.ekfc.cr}
\alias{egfr.ekfc.cr}
\title{Calculate eGFR by the EKFC creatinine-based equation}
\usage{
egfr.ekfc.cr(
  creatinine,
  age,
  sex,
  ethnicity = NA,
  creatinine_units = "micromol/l",
  label_sex_male = c("Male", 1),
  label_sex_female = c("Female", 0),
  label_african = c("African"),
  max_age = 100
)
}
\arguments{
\item{creatinine}{Numeric vector. Serum creatinine, could be expressed in "micromol/L", "mmol/L" or "mg/dL". Units of measurement should be defined in variable creatinine_units (if not defined explicitly by user, the default value is "micromol/L").}

\item{age}{Numeric vector. Age, in years.}

\item{sex}{Vector. The value of variable refers to the parameters label_sex_male and label_sex_female.}

\item{ethnicity}{Vector. Ethnicity. If no ethnicity will be defined, the calculation will use coefficients for White European subjects. Specify ethnicity if a study includes African and Black European subjects, and define the values of variable in the parameter label_african.}

\item{creatinine_units}{Character string. Units in which serum creatinne is expressed. Could be one of the following: "micromol/L", "mmol/L" or "mg/dL".}

\item{label_sex_male}{List. Label(s) for definition(s) of male sex.}

\item{label_sex_female}{List. Label(s) for definition(s) of female sex.}

\item{label_african}{List. Label(s) for African ethnicity.}

\item{max_age}{Numeric. Maximal age suitable for the equation application, in years. By default is 100 years, but change this value in case you would like to apply equation to older persons.}
}
\value{
numeric eGFR expressed in ml/min/1.73m\ifelse{html}{\out{<sup>2</sup>}}{\eqn{^2}}.
}
\description{
Calculate eGFR by the EKFC creatinine-based equation
}
\details{
Calculate estimated glomerular filtration rate (eGFR) by the EKFC creatinine-based equation.

References to the equation:  
\itemize{
  \item Initial creatinine-based equation was reported in Pottel H, Björk J, Courbebaisse M, et al. Development and validation of a modified full age spectrum creatinine-based equation to estimate glomerular filtration rate. a cross-sectional analysis of pooled data. Ann Int Med. 2021;174:183–192 doi:10.7326/M20-4366.
  \item Subsequent definition of Q coefficients for African and Black European subjects was reported in Pottel H, Björk J, Rule AD, et al. Cystatin C–based equation to estimate GFR without the inclusion of race and sex. N Engl J Med. 2023;388:333-343 doi: 10.1056/NEJMoa22037.
}

Citation: Bikbov B. kidney.epi: Kidney-Related Functions for Clinical and Epidemiological Research. Scientific-Tools.Org, https://Scientific-Tools.Org. DOI: 10.32614/CRAN.package.kidney.epi
}
\examples{
# for a single patient
egfr.ekfc.cr (creatinine = 1.4, age = 60, sex = "Male", 
  creatinine_units = "mg/dl")
# for a dataset - see vignettes for details
# egfr.ekfc.cr (creatinine = dta$scr, age = dta$age, sex = dta$sex, 
#  creatinine_units = "mg/dl")
}
\author{
Programming: Boris Bikbov https://www.linkedin.com/in/boris-bikbov.
}
