% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ckd_classify.R
\name{ckd.kdigo_category.albuminuria}
\alias{ckd.kdigo_category.albuminuria}
\title{Calculate KDIGO albuminuria categories}
\usage{
ckd.kdigo_category.albuminuria(
  albuminuria,
  albuminuria_units = "mg/g",
  semiquantitative_values = "forbidden"
)
}
\arguments{
\item{albuminuria}{Numeric vector. Urine albumin, could be expressed in "mg/day" (24-hour urine collection), "mg/mmol" (UACR) or "mg/g" (UACR). Units of measurement should be defined in variable albuminuria_units (if not defined explicitly by user, the default value is "mg/g").}

\item{albuminuria_units}{Character string. Units in which urine albumin is measured. Could be one of the following: "mg/day", "mg/mmol" or "mg/g".}

\item{semiquantitative_values}{Character string. Defines whether semiquantitative values are allowed in the data. If "any", all semiquantitative values ('<30', '30-300', '>300') and any numeric values (29, 30, 35, etc) will be classified into A categories (NB! both '30-300' and '30-299' will be classified as A2). If "only_limits", only limiting semiquantitative values ('<30', '>300') will be classified into A categories, but middle semiquantitative values ('30-300') will be omitted; but numeric values (29, 30, 35, etc) will be classified into A categories. If "forbidden", only numeric values will be classified into A categories.}
}
\value{
string albuminuria category.
}
\description{
Calculate KDIGO albuminuria categories
}
\details{
Calculate albuminuria categories (A1, A2, A3) based on albuminuria values.

Citation: Bikbov B. kidney.epi: Kidney-Related Functions for Clinical and Epidemiological Research. Scientific-Tools.Org, https://Scientific-Tools.Org. DOI: 10.32614/CRAN.package.kidney.epi
}
\examples{
# for a single patient
ckd.kdigo_category.albuminuria(albuminuria = 25, albuminuria_units = "mg/g")
# for a dataset - see vignettes for details
# ckd.kdigo_category.albuminuria(albuminuria = dta$alb, albuminuria_units = "mg/g")
}
\author{
Programming: Boris Bikbov https://www.linkedin.com/in/boris-bikbov.
}
