% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernelboot-methods.R
\name{kernelboot-class}
\alias{kernelboot-class}
\title{'kernelboot' class object}
\description{
'kernelboot' class object
}
\details{
Object of class \code{"kernelboot"}, is a list with components including

\tabular{ll}{
\code{orig.stat}          \tab  estimates from \code{statistic} on the original data, \cr
\code{boot.samples}       \tab  samples drawn, \cr
\code{call}               \tab  function call, \cr
\code{statistic}          \tab  actual \code{statistic} function that was used, \cr
\code{orig.data}          \tab  original data used for bootstrapping, \cr
\code{variables}          \tab  used variables: it is \code{NULL} for univariate data and
                                for multivariate data it contains two lists of \code{smoothed}
                                and \code{ignored} variables (names or column indexes) during
                                the smoothing phase. \cr
\code{type}               \tab  type of kernel density that was used ("univariate", "product",
                                "multivariate"), \cr
\code{param}              \tab  list of parameters that were used.
}

\code{param} section contains:

\tabular{ll}{
\code{R}                  \tab  number of bootstrap iterations, \cr
\code{bw}                 \tab  the bandwidth that was used, \cr
\code{weights}            \tab  vector of the weights that were applied, \cr
\code{kernel}             \tab  name of the kernel that was used ("multivariate",
                                "gaussian", "epanechnikov", "rectangular",
                                "triangular", "biweight", "cosine", "optcosine",
                                "none"), \cr
\code{shrinked}           \tab  value of the \code{shrinked} parameter, \cr
\code{parallel}           \tab  indicates if parallel computation was used, \cr
\code{random.seed}        \tab  random seed used to initialize the random number
                                generator (see \code{\link[base]{.Random.seed}}).
}
}
\seealso{
\code{\link{kernelboot}}
}
