## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----eval=FALSE---------------------------------------------------------------
# if(!require("devtools")){
#   install.packages("devtools")
#   library("devtools")
# }
# 
# if(!require("kdps")){
#   devtools::install_github("UCSD-Salem-Lab/kdps")
#   library("kdps")
# }

## ----eval=FALSE---------------------------------------------------------------
# library(kdps)
# 
# phenotype_file = system.file("extdata", "simple_pheno.txt", package = "kdps")
# kinship_file   = system.file("extdata", "simple_kinship.txt", package = "kdps")
# 
# kdps_results = kdps(
#   phenotype_file = phenotype_file,
#   kinship_file = kinship_file,
#   fuzziness = 0,
#   phenotype_name = "pheno2",
#   prioritize_high = FALSE,
#   prioritize_low = FALSE,
#   phenotype_rank = c("DISEASED1", "DISEASED2", "HEALTHY"),
#   fid_name = "FID",
#   iid_name = "IID",
#   fid1_name = "FID1",
#   iid1_name = "IID1",
#   fid2_name = "FID2",
#   iid2_name = "IID2",
#   kinship_name = "KINSHIP",
#   kinship_threshold = 0.0442,
#   phenotypic_naive = FALSE
# )
# 
# kdps_results

## ----eval=FALSE---------------------------------------------------------------
# write.table(kdps_results, file = "subjects_to_remove.txt", quote = FALSE, row.names = FALSE)

