% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{SC_test}
\alias{SC_test}
\title{Script concordance test (SCT).}
\format{
A matrix with 34 rows and 50 columns. Columns 1 to 39 are student
raters, columns 40 to 50 are experts. Each rater applies to each clinical
situation one of five levels ranging from -2 to 2 with the following
meaning:
\describe{
\item{-2}{The assumption is practically eliminated;}
\item{-1}{The assumption becomes less likely;}
\item{0}{The information has no effect on the assumption;}
\item{+1}{The assumption becomes more likely;}
\item{+2}{The assumption is virtually the only possible one.}
}
}
\source{
Sophie Vanbelle (personal communication, 2021)
}
\usage{
SC_test
}
\description{
In medical education, the script concordance test (SCT) (Charlin, Gagnon,
Sibert, & Van der Vleuten, 2002) is used to score physicians or medical
students in their ability to solve clinical situations as compared to answers
given by experts. The test consists of a number of items to be evaluated on a
5-point Likert scale.
}
\details{
Each item represents a clinical situation (called an 'assumption') likely to
be encountered in the physician’s practice. The situation has to be unclear,
even for an expert. The task of the subjects being evaluated is to consider
the effect of new information on the assumption to solve the situation. The
data incorporates 50 raters, 39 students and 11 experts.

Each rater judges the same 34 assumptions.
}
\references{
Vanbelle, S., Albert, A. Agreement between Two Independent Groups
of Raters. Psychometrika 74, 477–491 (2009).
\doi{10.1007/s11336-009-9116-1}
}
\keyword{datasets}
