% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resp01_functions.R
\name{resp01_counts_cfun}
\alias{resp01_counts_cfun}
\title{Content Row Function for Counts of Subgroups in Response Tables (RESP01)}
\usage{
resp01_counts_cfun(df, labelstr, .spl_context, .alt_df, label_fstr)
}
\arguments{
\item{df}{(\code{data.frame})\cr data set containing all analysis variables.}

\item{labelstr}{(\code{character})\cr label of the level of the parent split currently being summarized
(must be present as second argument in Content Row Functions). See \code{\link[rtables:summarize_row_groups]{rtables::summarize_row_groups()}}
for more information.}

\item{.spl_context}{(\code{data.frame})\cr gives information about ancestor split states
that is passed by \code{rtables}.}

\item{.alt_df}{(\code{data.frame})\cr alternative data frame used for denominator calculation.}

\item{label_fstr}{(\code{string})\cr format string for the label.}
}
\value{
The correct \code{\link[rtables:in_rows]{rtables::in_rows()}} result.
}
\description{
Content Row Function for Counts of Subgroups in Response Tables (RESP01)
}
\examples{
fake_spl_context <- data.frame(
  cur_col_split_val = I(list(c(ARM = "A: Drug X", count_prop = "count_prop")))
)
resp01_counts_cfun(
  df = DM,
  labelstr = "Blue",
  .spl_context = fake_spl_context,
  .alt_df = DM,
  label_fstr = "Color: \%s"
)
}
