% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jubilee-eqty-ols-method.R
\name{jubilee.eqty_ols}
\alias{jubilee.eqty_ols}
\title{Internal utility to calculate OLS regression for log total return index}
\usage{
jubilee.eqty_ols(dtb, end.frac, lookback.channel, tol.frac = 1/6)
}
\arguments{
\item{dtb}{data.table that contains \code{fraction} and \code{log.tri} columns.}

\item{end.frac}{numeric, the ending fraction of regression.}

\item{lookback.channel}{numeric, the backward-looking regression period}

\item{tol.frac}{numeric, tolerance of missing data in the beginning, expressed as fraction.
Default is 1/6, that is, two months.}
}
\value{
two-element array \code{c(a,R)} if \code{end.frac} is length-one;
     data.table with \code{end.frac} as fraction column if \code{end.frac} is an array.
}
\description{
Calculate the OLS regression for log total return index
}
\examples{
  \dontrun{
    dtb <- jubilee.repo(online=FALSE)@ie
    jubilee.eqty_ols(dtb, 1970, 50) # c(11.8671626, 0.1008371)
 }
}
\author{
Stephen H. Lihn
}
\keyword{utility}
