% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_generics.R
\name{functionals}
\alias{functionals}
\alias{d,Distribution,missing-method}
\alias{p,Distribution,missing-method}
\alias{qn,Distribution,missing-method}
\alias{r,Distribution,missing-method}
\alias{ll,Distribution,missing-method}
\alias{mle,Distribution,missing-method}
\alias{me,Distribution,missing-method}
\alias{same,Distribution,missing-method}
\title{Distribution Functionals}
\usage{
\S4method{d}{Distribution,missing}(distr, x, ...)

\S4method{p}{Distribution,missing}(distr, q, ...)

\S4method{qn}{Distribution,missing}(distr, p, ...)

\S4method{r}{Distribution,missing}(distr, n, ...)

\S4method{ll}{Distribution,missing}(distr, x, ...)

\S4method{mle}{Distribution,missing}(distr, x, ...)

\S4method{me}{Distribution,missing}(distr, x, ...)

\S4method{same}{Distribution,missing}(distr, x, ...)
}
\arguments{
\item{distr}{a \code{Distribution} object.}

\item{x, q, p, n}{missing. Arguments not supplied.}

\item{...}{extra arguments.}
}
\value{
When supplied with one argument, the \code{d()}, \code{p()}, \code{q()}, \code{r()} \code{ll()}
functions return the density, cumulative probability, quantile, random sample
generator, and log-likelihood functions, respectively.
}
\description{
A collection of S4 classes that provide a flexible and structured way to work
with probability distributions.
}
\details{
When \code{x}, \code{q}, \code{p}, or \code{n} are missing, the methods return a function that
takes as input the missing argument, allowing the user to work with the
function object itself. See examples.
}
\examples{
# -----------------------------------------------------
# Beta Distribution Example
# -----------------------------------------------------

# Create the distribution
a <- 3
b <- 5
D <- Beta(a, b)

# ------------------
# dpqr Functions
# ------------------

d(D, c(0.3, 0.8, 0.5)) # density function
p(D, c(0.3, 0.8, 0.5)) # distribution function
qn(D, c(0.4, 0.8)) # inverse distribution function
x <- r(D, 100) # random generator function

# alternative way to use the function
df <- d(D) ; df(x) # df is a function itself

# ------------------
# Moments
# ------------------

mean(D) # Expectation
var(D) # Variance
sd(D) # Standard Deviation
skew(D) # Skewness
kurt(D) # Excess Kurtosis
entro(D) # Entropy
finf(D) # Fisher Information Matrix

# List of all available moments
mom <- moments(D)
mom$mean # expectation

# ------------------
# Point Estimation
# ------------------

ll(D, x)
llbeta(x, a, b)

ebeta(x, type = "mle")
ebeta(x, type = "me")
ebeta(x, type = "same")

mle(D, x)
me(D, x)
same(D, x)
e(D, x, type = "mle")

mle("beta", x) # the distr argument can be a character

# ------------------
# Estimator Variance
# ------------------

vbeta(a, b, type = "mle")
vbeta(a, b, type = "me")
vbeta(a, b, type = "same")

avar_mle(D)
avar_me(D)
avar_same(D)

v(D, type = "mle")
}
\seealso{
\link{moments}, \link{loglikelihood}, \link{estimation}, \link{Bern},
\link{Beta}, \link{Binom}, \link{Cat}, \link{Cauchy}, \link{Chisq}, \link{Dir}, \link{Exp},
\link{Fisher}, \link{Gam}, \link{Geom}, \link{Laplace}, \link{Lnorm}, \link{Multigam}, \link{Multinom},
\link{Nbinom}, \link{Norm}, \link{Pois}, \link{Stud}, \link{Unif}, \link{Weib}
}
