test_that("prep_data_cif prepares treatment and control subsets", {
  data(main_df, package = "jointCompRisk")

  prepped <- prep_data_cif(
    data             = main_df,
    ID               = "ID",
    TimeToRecovery   = "TimeToRecovery",
    TimeToDeath      = "TimeToDeath",
    Recov_Censoring  = "RecoveryCensoringIndicator",
    Death_Censoring  = "DeathCensoringIndicator",
    Treatment        = "Treatment"
  )

  expect_s3_class(prepped$data.w, "data.frame")
  expect_true(all(c("cn", "etime", "estatus", "etype2", "Treatment") %in% names(prepped$data.w)))
  expect_true(all(prepped$Treatment$Treatment == 1))
  expect_true(all(prepped$Control$Treatment == 0))
})

test_that("do_cif_analysis returns formatted summaries", {
  data(main_df, package = "jointCompRisk")
  prepped <- prep_data_cif(
    data             = main_df,
    ID               = "ID",
    TimeToRecovery   = "TimeToRecovery",
    TimeToDeath      = "TimeToDeath",
    Recov_Censoring  = "RecoveryCensoringIndicator",
    Death_Censoring  = "DeathCensoringIndicator",
    Treatment        = "Treatment"
  )

  res <- do_cif_analysis(prepped, tau = 15)
  expect_named(res, c("RMLT1", "RMLT2"))
  expect_s3_class(res$RMLT1$groups, "data.frame")
  expect_s3_class(res$RMLT1$contrast, "data.frame")
  expect_false(anyNA(res$RMLT1$contrast$Estimate))
})

test_that("weighted prep and analysis succeed with default settings", {
  data(main_df, package = "jointCompRisk")
  data(long_df, package = "jointCompRisk")

  prepped_w <- prep_data_weighted_cif(
    data_main = main_df,
    data_long = long_df,
    wID_main = "ID",
    wTimeToRecovery_main = "TimeToRecovery",
    wTimeToDeath_main = "TimeToDeath",
    wRecov_Censoring_main = "RecoveryCensoringIndicator",
    wDeath_Censoring_main = "DeathCensoringIndicator",
    wBaselineScore_main = "BaselineScore",
    wTreatment_main = "Treatment",
    wID_long = "PersonID",
    wADY_long = "RelativeDay",
    wScore_long = "OrdinalScore"
  )

  expect_true(all(c("Treatment.death", "Control.discharge") %in% names(prepped_w)))
  expect_true(all(!is.na(prepped_w$Treatment.death$wU)))

  res_w <- do_weighted_cif_analysis(prepped_w, tau = 15)
  expect_named(res_w, c("WRMLT1", "WRMLT2"))
  expect_s3_class(res_w$WRMLT1$groups, "data.frame")
  expect_s3_class(res_w$WRMLT2$contrast, "data.frame")
  expect_false(anyNA(res_w$WRMLT2$contrast$Estimate))
})
