% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/itrax_munsell.R
\name{itrax_munsell}
\alias{itrax_munsell}
\title{Convert an Itrax Image File into Munsell Colour}
\usage{
itrax_munsell(image, proportion = 0.1)
}
\arguments{
\item{image}{defines the name of the image file imported using `itrax_image()`. It is essential that the image has been colour calibrated using a colour card or other method.}

\item{proportion}{defines the width down the centre of the image to use for processing}
}
\value{
a table of values
}
\description{
Reads a colour calibrated Itrax image file and processes it to estimate Munsell colour.
}
\examples{
\dontrun{
itrax_image(file = system.file("extdata",
                              "CD166_19_S1_optical_lowres.tif",
                              package = "itraxR",
                              mustWork = TRUE),
           meta = system.file("extdata",
                              "CD166_19_S1_xrf_document.txt",
                              package = "itraxR",
                              mustWork = TRUE),
           plot = FALSE) \%>\%
 magrittr::extract2(1) \%>\%
 itrax_munsell() \%>\%
 dplyr::slice_sample(n = 10)
 }


}
