% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output.R
\name{write_hub}
\alias{write_hub}
\title{Write all data object into files}
\usage{
write_hub(object, dir = getwd(), with_tree = FALSE)
}
\arguments{
\item{object}{itol.hub object holds the complete data and theme information.
This is an all-in-one object that collects all the information. Based on this
object, it is possible to export template files directly. It can also be
converted to an operation unit object for the detailed processing of
individual datasets. The object can also be saved locally for reproducible
visualization to share. This object contains species or sample clustering
trees, sequence alignment, species abundance or gene expression table,
multi-level taxonomic information, metadata, and a list of custom themes.
Each element name in the theme list is prefixed with the column name of the
metadata and is used to establish the association between the theme and the
data. For some special dataset types, the storage location is not in the
metadata, but it also conforms to the association with themes. The program
automatically decides where to read the data according to the different
output template types. The user only needs to explicitly define the theme
name to be output consistent with the data name prefix.}

\item{dir}{output dir path. Define the output files location using absolute
or relative path. The template files will output by the key information from
theme name in the hub object.}

\item{with_tree}{output with tree file in newick format.}
}
\value{
No return value, only output template files
}
\description{
Write itol.hub object into template files.
}
\examples{
tree <- system.file("extdata",
                    "tree_of_itol_templates.tree",
                    package = "itol.toolkit")
hub <- create_hub(tree = tree)
data("template_groups")
df_group <- data.frame(id = unique(template_groups$group),
                       data = unique(template_groups$group))
## create unit
unit_1 <- create_unit(data = df_group,
                      key = "Quickstart_1",
                      type = "TREE_COLORS",
                      subtype = "clade",
                      line_type = c(rep("normal",4),"dashed"),
                      size_factor = 5,
                      tree = tree)
unit_2 <- create_unit(data = df_group,
                      key = "Quickstart_2",
                      type = "DATASET_COLORSTRIP",
                      tree = tree)
## write hub
hub <- hub + unit_1 + unit_2
write_hub(hub,tempdir())
}
