% Generated by roxygen2 (4.0.1): do not edit by hand
\name{ichunk}
\alias{ichunk}
\title{Iterator that returns elements in fixed-length chunks}
\usage{
ichunk(object, chunk_size = 1, fill = NA)
}
\arguments{
\item{object}{an iterable object}

\item{chunk_size}{the number of elements returned per chunk}

\item{fill}{the value with which to fill the last chunk if the length of the
iterator is not divisble by \code{chunk_size}}
}
\value{
each call to \code{nextElem} results in a list of length
\code{chunk_size}
}
\description{
Constructs an iterator that returns elements of an iterable \code{object} in
fixed-length chunks. If the length of the iterator is not divisible by
\code{chunk_size}, the remainder of the last block is filled with the value
specified in \code{fill}.
}
\details{
This function corresponds to Python's \code{grouper} function. We chose the
name \code{ichunk} because it more explicitly defines the function's purpose.
}
\examples{
it <- ichunk(iterators::iter(1:5), chunk_size=2)
# List: list(1, 2, 3)
iterators::nextElem(it)
# List: list(4, 5, NA)
iterators::nextElem(it)

it2 <- ichunk(levels(iris$Species), chunk_size=4, "weeee")
# Returns: list("setosa", "versicolor", "virginica", "weeee")
iterators::nextElem(it2)
}

