% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampling_frequency_iteration.R
\name{sampling_frequency_iteration}
\alias{sampling_frequency_iteration}
\title{Frequency and Density plot based on its iteration}
\usage{
sampling_frequency_iteration(
  irace_results,
  param_name,
  numerical_type = "both",
  filename = NULL
)
}
\arguments{
\item{irace_results}{The data generated when loading the \code{.Rdata} file created by \code{irace} (or the filename of that file).}

\item{param_name}{String, name of the parameter to be included (example: param_name = "algorithm")}

\item{numerical_type}{String, (default "both") Indicates the type of plot to be displayed for numerical
parameters. "density" shows a density plot, "frequency" shows a frequency plot and
"both" show both frequency and density.}

\item{filename}{(\code{character(1)}) File name to save the plot, for example \code{"~/path/example/filename.png"}.}
}
\value{
Frequency and/or density plot
}
\description{
The function will return a frequency plot used
for categorical data (its values are string, show a bar plot) or
numeric data (show a histogram and density plot) by each iteration
}
\examples{
iraceResults <- read_logfile(system.file(package="irace", "exdata",
                                         "irace-acotsp.Rdata", mustWork = TRUE))
sampling_frequency_iteration(iraceResults, param_name = "alpha")
\donttest{ 
sampling_frequency_iteration(iraceResults, param_name = "alpha", numerical_type="density")
}
}
