% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ops.R
\name{ir_subtract}
\alias{ir_subtract}
\title{Subtract infrared spectra}
\usage{
ir_subtract(x, y)
}
\arguments{
\item{x}{An object of class \code{\link[=ir_new_ir]{ir}}.}

\item{y}{An object of class \code{\link[=ir_new_ir]{ir}} or a numeic value. If \code{y}
is an object of class \code{ir}, it must have the same number of rows as
\code{x} and the same x axis values (e.g. wavenumber values) in each matching
spectrum as in \code{x}.}
}
\value{
\code{x} where for each spectrum the respective intensity values in
\code{y} are subtracted (if \code{y} is an object of class \code{ir}), or
where for each spectrum \code{y} has been subtracted from the intensity
values.
}
\description{
\code{ir_subtract} takes two objects of class \code{ir}, \code{x} and
\code{y}, and subtracts the intensity values of spectra in matching rows from
\code{y} from that of \code{x}. Alternatively, takes an object of class
\code{ir}, \code{x}, and a numeric value, \code{y}, and subtracts \code{y}
from all intensity values in \code{x}.
}
\examples{
# subtracting two objects of class ir
x1 <-
  ir::ir_subtract(ir::ir_sample_data, ir::ir_sample_data)
x2 <-
  ir::ir_subtract(ir::ir_sample_data, ir::ir_sample_data[1, ])

# subtracting a numeric value from an object of class `ir`.
x3 <-
  ir::ir_subtract(ir::ir_sample_data, 20)

# subtracting a numeric vector from an object of class `ir`.
x4 <-
  ir::ir_subtract(
     ir::ir_sample_data,
     seq(from = 0, to = 2, length.out = nrow(ir::ir_sample_data))
  )

}
