% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ipa.R
\name{ipa}
\alias{ipa}
\title{Convert phonetic representation from IPA}
\usage{
ipa(x, to = c("xsampa", "arpabet"))
}
\arguments{
\item{x}{A phonetic character vector in IPA}

\item{to}{The phonetic alphabet to convert to.
Defaults to \code{"xsampa"}.
\code{"sampa"} is an accepted alias for \code{"xsampa"}.
\code{"arpa"} and \code{"cmu"} are accepted aliases for \code{"arpabet"}.}
}
\value{
A character vector the same length as \code{x}
}
\description{
Converts to X-SAMPA or ARPABET (used by the CMU Pronouncing Dictionary)
}
\examples{
# `ipa()` supports raw Unicode input or escaped Unicode sequences (\uxxxx),
# but raw Unicode is not supported in R package documentation,
# hence the ugly examples
ipa("\\\\u02cch\\\\u025b\\\\'lo\\\\u028a")
ipa(c("\\\\u02cch\\\\u025b\\\\'lo\\\\u028a", "w\\\\u025dld"))

ipa("\\\\u02cch\\\\u025b\\\\'lo\\\\u028a", to = "arpabet")
ipa(c("\\\\u02cch\\\\u025b\\\\'lo\\\\u028a", "w\\\\u025dld"), to = "arpabet")
}
\seealso{
\code{\link[=convert_phonetics]{convert_phonetics()}} to convert between any phonetic
representations

\code{\link[=sampa]{sampa()}} and \code{\link[=xsampa]{xsampa()}} to convert from X-SAMPA

\code{\link[=arpa]{arpa()}}, \code{\link[=arpabet]{arpabet()}} and \code{\link[=cmu]{cmu()}} to convert from ARPABET (CMU)
}
