% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ai.R
\name{dComposite}
\alias{dComposite}
\title{Estimates the d of a composite.}
\usage{
dComposite(rxx, d_vec, wt_vec = rep(1, length(d_vec)))
}
\arguments{
\item{rxx}{A matrix of predictor intercorrelations.}

\item{d_vec}{A vector containing d's for each predictor.}

\item{wt_vec}{A vector containing the weights of each item in rxx.}
}
\value{
A vector of correlation coefficients.
}
\description{
Estimates the d of a composite.
}
\note{
This is essentially the same function as solveWt().
}
\examples{
Rxx <- matrix(.3, 3, 3); diag(Rxx) <- 1
ds  <- c(.2, .4, .3)
dComposite(rxx = Rxx, d_vec = ds)

Rxx <- matrix(c(1.0, 0.3, 0.2, 
                0.3, 1.0, 0.1,
                0.2, 0.1, 1.0), 3, 3)
ds  <- c(.1, .3, .7)
ws  <- c(1, .5, .5)
dComposite(rxx = Rxx, d_vec = ds, wt_vec = ws)
}
\author{
Jeff Jones and Allen Goebl
}
\references{
Sackett, P. R., & Ellingson, J. E. (1997). \emph{Personnel 
Psychology.}, 50(3), 707-721.
}

