% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_icm_stanfit.R
\name{plot.icm_stanfit}
\alias{plot.icm_stanfit}
\title{Plot Method for icm_stanfit Objects}
\usage{
\method{plot}{icm_stanfit}(x, ...)
}
\arguments{
\item{x}{An object of class \code{icm_stanfit}.}

\item{...}{Additional arguments passed to the \code{plot_consensus} function.}
}
\value{
A plot generated by the \code{\link[=plot_consensus]{plot_consensus()}} function.
}
\description{
This function provides a plot method for objects of class \code{icm_stanfit}.
}
\examples{
\donttest{
# Create minimal example data
df_simplex <- data.frame(
  x1 = c(0.3, 0.4, 0.2, 0.5),
  x2 = c(0.3, 0.2, 0.4, 0.2),
  x3 = c(0.4, 0.4, 0.4, 0.3)
)
id_person <- c(1, 1, 2, 2)
id_item <- c(1, 2, 1, 2)

# Fit ICM model
fit <- fit_icm(df_simplex, id_person, id_item, n_chains = 1,
               iter_sampling = 100, iter_warmup = 100,
               refresh = 0)

# Plot using S3 method
plot(fit)
}

}
\seealso{
\code{\link[=plot_consensus]{plot_consensus()}}
}
