% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/naive_b.R
\name{naive_b}
\alias{naive_b}
\title{Initial values for the sieve maximum likelihood estimation}
\usage{
naive_b(data, w = NULL, v, u, c, q, k = 1)
}
\arguments{
\item{data}{a data frame that includes the variables named in each argument}

\item{w}{a left-truncation time (default is \code{w = NULL}.)}

\item{v}{the last observation time prior to the failure}

\item{u}{the first observation time after the failure}

\item{c}{an indicator of cause of failure, for example, if an observation is righ-censored, \code{event = 0}; otherwise, \code{event = 1} or \code{event = 2}, where \code{1} represents the first cause of failure, and \code{2} represents the second cause of failure. The current version of package only allows for two causes of failure.}

\item{q}{a number of parameters in design matrix}

\item{k}{a parameter that controls the number of knots in the B-spline with \eqn{0.5 \le }\code{k}\eqn{ \le 1}}
}
\value{
Initial values of B-spline estimation
\item{b}{a vector of the initial values to be used in the optimization process}
}
\description{
The function \code{naive_b} provides a vector of initial values for the B-spline sieve maximum likelihood estimation.
}
\details{
The function \code{naive_b} provides initial values for the optimization procedure.
}
\examples{
attach(simdata)
intccr:::naive_b(data = simdata, v = v, u = u, c = c, q = 2)
}
\author{
Giorgos Bakoyannis, \email{gbakogia@iu.edu}

Jun Park, \email{jun.park@alumni.iu.edu}
}
\keyword{naive_b}
