% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DroppingInterval.R
\name{loglikinterval}
\alias{loglikinterval}
\title{log-likelihood of an observed interval distribution}
\usage{
loglikinterval(
  data,
  mu,
  sigma,
  p,
  N = 5L,
  fun = "gamma",
  trunc = c(0, Inf),
  fpp = 0
)
}
\arguments{
\item{data}{A numeric list of intervals.}

\item{mu}{mean arrival interval.}

\item{sigma}{standard deviation of the arrival interval.}

\item{p}{chance to not observe an arrival.}

\item{N}{Maximum number of missed observations to be taken into account (default N=5).}

\item{fun}{Assumed distribution for the intervals, one of "\code{normal}" or "\code{gamma}", corresponding
to the \link[stats]{Normal} and \link[stats]{GammaDist} distributions}

\item{trunc}{Use a truncated probability density function with range \code{trunc}}

\item{fpp}{Baseline proportion of intervals distributed as a random poisson process with mean arrival interval \code{mu}}
}
\value{
returns the value of the loglikelihood
}
\description{
log-likelihood of an observed interval distribution
}
\details{
Refer to \link[intRvals]{intervalpdf} for details on the functional form of
the probability density function of an observed interval distribution \eqn{\phi_{obs}}.
The log-likelihood \eqn{L} given a set of intervals {\eqn{x_j}} in \code{data} is given by
\deqn{L(\mu,\sigma,p)=\log \sum_j \phi_{obs}(x_j | \mu,\sigma,p)}
The function is provided to allow likelihood maximisation by other optimization
tools than the default by \link[stats]{optim}.
}
\examples{
data(goosedrop)
loglikinterval(goosedrop$interval,mu=200,sigma=50,p=.3)
}
