% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RStudio_CRAN_data.R
\name{download_RStudio_CRAN_data}
\alias{download_RStudio_CRAN_data}
\title{Download RStudio CRAN mirror data files into a folder}
\usage{
download_RStudio_CRAN_data(
  START = as.Date(Sys.time()) - 5,
  END = as.Date(Sys.time()),
  log_folder = tempdir(),
  trunc_END_date_to_today = TRUE,
  override = FALSE,
  message = TRUE,
  ...
)
}
\arguments{
\item{START}{the defaults is 5 days before today. A character string of the START date for files to be downloaded. The date format is "YYYY-MM-DD".}

\item{END}{the defaults is today. A character string of the END date for files to be downloaded. 
The date format is "YYYY-MM-DD".}

\item{log_folder}{the folder into which we would like the files to be downloaded to. Default is the temporary folder picked by \link{tempdir}.}

\item{trunc_END_date_to_today}{default is TRUE. Makes sure that if END date is later then today,
the END date will be change to today
(since otherwise, we will only get many 404 errors)}

\item{override}{boolean (default is FALSE) - should the function download files that
are already available in the temp folder}

\item{message}{boolean (default is TRUE) - should a message be printed in interesting cases.}

\item{...}{not in use.}
}
\value{
Returns the value of log_folder.
}
\description{
This function download these files based on the code from the download page (\url{http://cran-logs.rstudio.com/}) into a temporary folder.
}
\details{
RStudio maintains its own CRAN mirror, https://cran.rstudio.com/ and offers its log files.
}
\examples{
\dontrun{
# The first two functions might take a good deal of time to run (depending on the date range)
RStudio_CRAN_data_folder <- 
      download_RStudio_CRAN_data(START = '2013-04-02',
                                 END = '2013-04-05') 
                                 # around the time R 3.0.0 was released
# RStudio_CRAN_data_folder <- download_RStudio_CRAN_data()
my_RStudio_CRAN_data <- read_RStudio_CRAN_data(RStudio_CRAN_data_folder)

# barplots: (more functions can easily be added in the future)
barplot_package_users_per_day("installr", my_RStudio_CRAN_data)
barplot_package_users_per_day("plyr", my_RStudio_CRAN_data)
}
}
\seealso{
\link{download_RStudio_CRAN_data}, \link{read_RStudio_CRAN_data},\link{barplot_package_users_per_day}
}
