% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_functions.R
\name{summary.inlamemi}
\alias{summary.inlamemi}
\alias{print.summary.inlamemi}
\title{Summary method for inlamemi}
\usage{
\method{summary}{inlamemi}(object, ...)

\method{print}{summary.inlamemi}(x, ...)
}
\arguments{
\item{object}{model of class `inlamemi`.}

\item{...}{other arguments}

\item{x}{object of class summary.inlamemi.}
}
\value{
`summary.inlamemi` returns an object of class `summary.inlamemi`, a list of components to print.
}
\description{
Takes a fitted `inlamemi` object produced by
`fit_inlamemi` and produces a summary from it.
}
\examples{
\dontshow{if (requireNamespace('INLA')) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Fit the model
simple_model <- fit_inlamemi(data = simple_data,
                           formula_moi = y ~ x + z,
                           formula_imp = x ~ z,
                           family_moi = "gaussian",
                           error_type = c("berkson", "classical"),
                           prior.prec.moi = c(10, 9),
                           prior.prec.berkson = c(10, 9),
                           prior.prec.classical = c(10, 9),
                           prior.prec.imp = c(10, 9),
                           prior.beta.error = c(0, 1/1000),
                           initial.prec.moi = 1,
                           initial.prec.berkson = 1,
                           initial.prec.classical = 1,
                           initial.prec.imp = 1)

summary(simple_model)
\dontshow{\}) # examplesIf}
}
