# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title Filter and sort matrix
#'
#' @param network_matrix The matrix of network weight.
#' @param regulators Regulators list.
#' @param targets Targets list.
#'
#' @return Filtered and sorted matrix
#' @export
#'
#' @examples
#' data(example_matrix)
#' network_table <- inferCSN(example_matrix)
#' colnames(network_table) <- c("row", "col", "value")
#' network_matrix <- thisutils::table_to_matrix(network_table)
#' filter_sort_matrix(network_matrix)[1:6, 1:6]
#'
#' filter_sort_matrix(
#'   network_matrix,
#'   regulators = c("g1", "g2"),
#'   targets = c("g3", "g4")
#' )
filter_sort_matrix <- function(network_matrix, regulators = NULL, targets = NULL) {
    .Call('_inferCSN_filter_sort_matrix', PACKAGE = 'inferCSN', network_matrix, regulators, targets)
}

prepare_calculate_metrics <- function(network_table, ground_truth) {
    .Call('_inferCSN_prepare_calculate_metrics', PACKAGE = 'inferCSN', network_table, ground_truth)
}

#' @title Format network table
#'
#' @param network_table The weight data table of network.
#' @param regulators Regulators list.
#' @param targets Targets list.
#' @param abs_weight Logical value, default is *`TRUE`*,
#' whether to perform absolute value on weights,
#' and when set `abs_weight` to *`TRUE`*,
#' the output of weight table will create a new column named `Interaction`.
#'
#' @md
#' @return Formated network table
#' @export
#'
#' @examples
#' data(example_matrix)
#' network_table <- inferCSN(example_matrix)
#'
#' network_format(
#'   network_table,
#'   regulators = "g1"
#' )
#'
#' network_format(
#'   network_table,
#'   regulators = "g1",
#'   abs_weight = FALSE
#' )
#'
#' network_format(
#'   network_table,
#'   targets = "g3"
#' )
#'
#' network_format(
#'   network_table,
#'   regulators = c("g1", "g3"),
#'   targets = c("g3", "g5")
#' )
network_format <- function(network_table, regulators = NULL, targets = NULL, abs_weight = TRUE) {
    .Call('_inferCSN_network_format', PACKAGE = 'inferCSN', network_table, regulators, targets, abs_weight)
}

#' @title Weight sift
#' @description Remove edges with smaller weights in the reverse direction.
#'
#' @param table A data frame with three columns: "regulator", "target", and "weight".
#'
#' @export
#'
#' @examples
#' data(example_matrix)
#' network_table <- inferCSN(example_matrix)
#' weight_sift(network_table) |> head()
weight_sift <- function(table) {
    .Call('_inferCSN_weight_sift', PACKAGE = 'inferCSN', table)
}

