% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/v3_denue.R
\name{inegi_denue}
\alias{inegi_denue}
\title{Returns DENUE businesses}
\usage{
inegi_denue(latitud, longitud, token, meters = 250, keyword = "todos")
}
\arguments{
\item{latitud}{Character vector with latitud (in decimals)}

\item{longitud}{Character vector with longitud (in decimals)}

\item{token}{API token supplied by INEGI}

\item{meters}{Meters to search in a circle from coordinates. Defaults to 250}

\item{keyword}{Keyword to search in business description (in spanish). Defaults to all (todos).}
}
\value{
Data.frame
}
\description{
Returns data.frame with businesses registered in DENUE in the vicinity of supplied coordinates.
}
\examples{
# All businesses in a 1 km radius from the Macroplaza in Monterrey, Mex.
\dontrun{
token<-"webservice_token"
latitud<- 25.669194
longitud<- -100.30990
businesses <- inegi_denue(latitud, longitud, token, meters = 1000)
}

}
\author{
Eduardo Flores
}
