% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rbindimpimp.R
\name{rbindimpimp}
\alias{rbindimpimp}
\title{Combine impimp Objects}
\usage{
rbindimpimp(x, y)
}
\arguments{
\item{x, y}{objects of class \code{"impimp"}. As such may contain
variables in form of tuples, they are not required to have the
same number of variables as returned from \code{ncol}.
However, they are required to have the same underlying variables.
If that condition is not satisfied an error is raised.}
}
\value{
An object of class \code{"impimp"}, inheriting the
attributes, specific to imimp objects, of \code{x} and \code{y}.
}
\description{
Combine two object of class \code{"impimp"}
like \code{rbind} would do with data frames.
}
\details{
The resulting object is constructed in such a way that minimizes
the creation of 'tupled' variables. Only those variables are joined
as tuples which are actually necessary to keep the data frame like
consise representation of impimp objects.

The attributes \code{"impmethod"} and \code{"varlevels"} contain
the set union of those of \code{x} and \code{y} on a global and
per underlying variable basis, respectively.
}
\examples{
A <- data.frame(x1 = c(1,0), x2 = c(0,0),
                y1 = c(1,0), y2 = c(2,2))
B <- data.frame(x1 = c(1,1,0), x2 = c(0,0,0),
                z1 = c(0,1,1), z2 = c(0,1,2))
impA <- impimp(A, B, method = "case_wise")
impB <- impimp(B, A, method = "case_wise")
rbindimpimp(impA, impB)

}
\seealso{
\code{\link{impimp}}
}
\keyword{datagen}
