#' Trump Social Network Data
#'
#'This folder contains network data for relationships between President Donald Trump and other people, which was originally compiled by John Templon, Anthony Cormier, Alex Campbell, and Jeremy Singer-Vine as part of a larger project of \href{https://www.buzzfeednews.com/article/johntemplon/help-us-map-trumpworld#.ru1M6Y21D}{mapping "TrumpWorld" for BuzzFeed News}.
#'
#'The full dataset, which you can access as \href{https://docs.google.com/spreadsheets/d/1Z5Vo5pbvxKJ5XpfALZXvCzW26Cl4we3OaN73K9Ae5Ss/edit#gid=1996904412}{a Google Sheet} or \href{https://github.com/BuzzFeedNews/trumpworld}{on GitHub} also includes information about organizations and agencies. The data was compiled by culling from "public records, news reports, and other sources on the Trump family, his Cabinet picks, and top advisers," as well as via crowdsourced tips and information from the public (\href{https://tips.huffpost.com}{if you have any more, you can contribute them here}].
#'
#'The relationships between President Donald Trump and other people lend themselves well to basic social network analysis because, as Templon, Cormier, Campbell, and Singer-Vine suggest, "No American president has taken office with a giant network of businesses, investments, and corporate connections like that amassed by Donald J. Trump."
#'
#'Further, the social network analysis of some of the most powerful people in the nation and the world might help contribute to what Lauren Klein called for at the end of her \href{http://lklein.com/2018/01/distant-reading-after-moretti/}{2018 MLA talk "Distant Reading After Moretti"}--that is, computational analysis "trained on power."
#'
#'
#' @name trump_network
#' @docType data
#' @usage
#' trump_network
#' @format
#' Nodes: 303; unimodal
#' Edges: 366; unweighted; undirected
#'
#'   This dataset is from Melanie Walsh. Prepared for R by Benjamin Smith
#' @source GitHub,
#'   <https://github.com/melaniewalsh/sample-social-network-datasets>
#' @keywords datasets
NULL
