% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cliques.R
\name{is_complete}
\alias{is_complete}
\title{Is this a complete graph?}
\usage{
is_complete(graph)
}
\arguments{
\item{graph}{The input graph.}
}
\value{
True if the graph is complete.
}
\description{
A graph is considered complete if there is an edge between all distinct
directed pairs of vertices. igraph considers both the singleton graph
and the null graph complete.
}
\examples{

g <- make_full_graph(6, directed = TRUE)
is_complete(g)
g <- delete_edges(g, 1)
is_complete(g)
g <- as_undirected(g)
is_complete(g)
}
\seealso{
\code{\link[=make_full_graph]{make_full_graph()}}

Other cliques: 
\code{\link{cliques}()},
\code{\link{ivs}()},
\code{\link{weighted_cliques}()}
}
\concept{cliques}
\keyword{graphs}
\section{Related documentation in the C library}{\href{https://igraph.org/c/html/0.10.17/igraph-Cliques.html#igraph_is_complete}{\code{is_complete()}}.}

