% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmi.R
\name{gmi}
\alias{gmi}
\title{Calculate GMI}
\usage{
gmi(data)
}
\arguments{
\item{data}{DataFrame object with column names "id", "time", and "gl",
or numeric vector of glucose values.}
}
\value{
If a data.frame object is passed, then a tibble object with
two columns: subject id and corresponding GMI is returned. If a vector of glucose
values is passed, then a tibble object with just the GMI value is returned.
as.numeric() can be wrapped around the latter to output just a numeric value.
}
\description{
The function gmi produces GMI values in a tibble object.
}
\details{
A tibble object with 1 row for each subject, a column for subject id and
a column for GMI values is returned. NA glucose values are
omitted from the calculation of the GMI.

GMI score is calculated by \eqn{3.31 + (.02392*mean(G))}
where G is the vector of Glucose Measurements (mg/dL).
}
\examples{

data(example_data_1_subject)
gmi(example_data_1_subject)

data(example_data_5_subject)
gmi(example_data_5_subject)

}
\references{
Bergenstal (2018) Glucose Management Indicator (GMI): A New Term for
Estimating A1C From Continuous Glucose Monitoring
\emph{Hormone and Metabolic Research} \strong{41} .2275-2280,
\doi{10.2337/dc18-1581}.
}
