% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bbase.R
\name{bbase_singletime}
\alias{bbase_singletime}
\title{Compute a B-spline basis for a single time point}
\usage{
bbase_singletime(x, xl = min(x), xr = max(x), nseg = 10, bdeg = 3)
}
\arguments{
\item{x}{The value for which the basis is to be evaluated (ONLY SINGLE VALUE ALLOWED)}

\item{xl}{The left boundary of the domain}

\item{xr}{The right boundary of the domain}

\item{nseg}{The number of inter-knot segments on the domain}

\item{bdeg}{The degree of the B-splines (2 means quadratic, 3 means cubic, and so on)}
}
\value{
A vector containing the basis
}
\description{
Similar to bbase_D, but sped up for single time points.
}
\examples{
x = 0.02
B = bbase_singletime(x, 0, 1, 20, 3)
}
\keyword{internal}
