% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stRCPP.R
\name{stRCPP}
\alias{stRCPP}
\title{Make state transitions using Rcpp.}
\usage{
stRCPP(origin, new.states, params, s.matrix)
}
\arguments{
\item{origin}{A number which represents the column index \code{s.matrix} you want to do the transition from}

\item{new.states}{A numeric vector or a number which represents the column index \code{s.matrix} you want
as the destination(s) for the transition}

\item{params}{A numeric vector of similar length to \code{new.states} which serves as the transition rate(s)}

\item{s.matrix}{A state matrix created from \code{syn_pop} function}
}
\value{
A transition matrix of the same dimension as \code{s.matrix}. -1 indicates that the individual has left
    the corresponding state. +1 indicates that the individual has become the corresponding state.
}
\description{
Take in the matrix of the states of synthetic population (created by \code{syn_pop} function)
and calculate the transitions from one state to other state(s) using the transition probabilities [not rate(s)].
The major difference from the R alone version was that instead of having the transition rate(s),
transition probabilities are used. These probabilities will thus be calculated with another function.
}
\examples{
pop <- syn_pop(c(19,1,0,0))
stRCPP(1,2,.1,pop)

}

