% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findSegments.R
\name{findSegments}
\alias{findSegments}
\title{Identify IBD segments}
\usage{
findSegments(
  data,
  ids = NULL,
  k1,
  a,
  err = 0,
  prepped = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{data}{Data frame with required columns \code{chrom}, \code{cm}, \code{a1} and \code{freq1}.}

\item{ids}{Genotype columns (default: last 2 columns).}

\item{k1, a}{HMM parameters. See \code{\link[=fitHMM]{fitHMM()}} for how to estimate these.}

\item{err}{Error rate; a single number in \verb{[0,1]} (default: 0).}

\item{prepped}{A logical indicating if the input data has been internally
processed. Can be ignored by most users.}

\item{verbose}{A logical.}
}
\value{
Data frame with IBD segments, described with columns \code{chrom},
\code{startCM}, \code{endCM} and \code{n} (the number of markers in the segment).
}
\description{
Identifies genomic segments shared identical-by-descent (IBD) between two
individuals from SNP marker data. The method applies a hidden Markov model
(HMM) along each chromosome, with states 0 (non-IBD) and 1 (IBD), and uses
the Viterbi algorithm to infer the most likely sequence of states.
}
\examples{
findSegments(cousinsDemo, k1 = 0.2, a = 5)

}
\seealso{
\code{\link[=plotIBD]{plotIBD()}}
}
