% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internals.R
\name{to_cambial_age}
\alias{to_cambial_age}
\title{to_cambial_age}
\usage{
to_cambial_age(rwl, po = NULL)
}
\arguments{
\item{rwl}{a data frame/rwl object.}

\item{po}{optional, a data frame containing series names in the first and po
data as nr. of years in the second column.}
}
\value{
A data.frame with aligned series
}
\description{
This function aligns tree ring series to match their cambial
ages, taking pith offset into account if provided.
}
\examples{
library("dplR")
data("gp.rwl")
data("gp.po")
gp.po$series <- as.character(gp.po$series)
iadf:::to_cambial_age(gp.rwl, gp.po)
}
